#ifndef _SWITCH_SETTINGS_H
#define _SWITCH_SETTINGS_H
/**
   swtichSettings.h
   by Matthew Ford, 
 * (c)2025 Forward Computing and Control Pty. Ltd.
 * NSW Australia, www.forward.com.au
 * This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 * This generated code may be freely used for both private and commercial use
 * provided this copyright is maintained.
*/

#include <Arduino.h>


void initSwitchSettings();
void updateSwitchSettings();
bool isBlanking();

// Getters for switchConfig fields for webpages.cpp
int getChargerOnTime();
int getChargerOffTime();
int getV2lOnTime();
int getV2lOffTime();
bool getChargerIsAuto();
bool getChargerIsOn();
bool getV2lIsAuto();
bool getV2lIsOn();

// Setters for switchConfig fields (each call sets switchConfigChanged=true after setting)
void setV2lSelected(bool value);
void setChargerOnTime(int value);
void setChargerOffTime(int value);
void setV2lOnTime(int value);
void setV2lOffTime(int value);
void setChargerIsAuto(bool value);
void setV2lIsAuto(bool value);

void setV2lIsOn(bool value); // these just set two volatiles for the loop() to process later, via updateSwitchSettings()
void setChargerIsOn(bool value);

#endif