#ifndef PINS_H
#define PINS_H
/**
   pins.h
   Pin allocations for EV_Charger_V2H_switch for Beetle esp32 V2
   For Beetle_ESP32 Select Firebeetle ESP32 for the board

   IO2 (D9) is the builtin led 

   
   by Matthew Ford,  2021/12/06
   (c)2021-2022 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au
   This code may be freely used for both private and commerical use.
   Provide this copyright is maintained.
*/

// pins for Beetle esp32 V2
// Wifi config led pin
static const int LED_PIN = D9; // gpio 2
// RELAY DRIVES
static const int CHARGER_1P_RELAY = D3;   // gpio26
static const int V2L_1P_RELAY = D2; // gpio26
static const int CHARGER_PP_PE_RELAY = D7; // gpio13
static const int V2L_PP_PE_RELAY = D4;  // gpio27
// PB INPUTS
static const int CHARGER_ON_OFF_PB = A1; // gpio39 , no pullup
static const int V2L_ON_OFF_PB = A2; // gpio34, no pullup

// 240VAC monitor input from relay contact
static const int AC_240V_ON = A0; //gpio36  , no pullup and noisy


#endif