/*
   locks.cpp
   by Matthew Ford,  2019/11/16
   (c)2019 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au

*/
// note ESP32 by default does NOT support static Semaphores

#include "locks.h"

/*  volatile alternative to locks

volatile unsigned char *my_data;
This declares my_data to be a pointer to volatile unsigned char.

To make the pointer itself volatile, you'd need this instead:
unsigned char *volatile my_data;

And of course, both the pointer and the pointed-to data may be volatile:
volatile unsigned char *volatile my_data;
*/

/** a lock control access by the Async webpage and main loop() */
SemaphoreHandle_t onOffLock = NULL;


/**
  creates all the locks needed.
  returns non-zero on error<br>
  can be called more than once
*/
bool initializeLocks() {
  if (onOffLock == NULL) {
    onOffLock = xSemaphoreCreateRecursiveMutex();
    if (onOffLock == NULL) {
      return false;
    }
  }
  // else
  return true;
}
