#ifndef FINALLY_H
#define FINALLY_H

/*
   finally.h
   by Matthew Ford,  2019/11/16
   (c)2019 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au
   copied from https://www.codeproject.com/Tips/476970/finally-clause-in-Cplusplus

*/

#include <functional>

/**
example of use

    while (  xSemaphoreTakeRecursive( deviceStatusLock, 0 ) == pdFAIL) {
      delay(10); // wait a few ms
    }
    try {
      finally returnSemaphore([&]{
        xSemaphoreGiveRecursive( deviceStatusLock );
        });
    } catch (char *ignore) {
    }

**/
class finally {
  std::function<void(void)> functor;
public:
  finally(const std::function<void(void)> &functor) : functor(functor) {}
  ~finally() {
    functor();
  }
};

#endif
