/*
   ESP32snptSupport.cpp
   by Matthew Ford,  2021/12/06
   (c)2021 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au
   This code may be freely used for both private and commerical use.
   Provide this copyright is maintained.
*/


#include <Arduino.h>
#include "ESP32sntpSupport.h"

#include "DebugOut.h"
#include <time.h>
#include <sys/time.h>
#include "esp_sntp.h"

/**
 * (c)2025 Forward Computing and Control Pty. Ltd.
 * NSW Australia, www.forward.com.au
 * This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 * This generated code may be freely used for both private and commercial use
 * provided this copyright is maintained.
*/

//#define DEBUG
static Print* debugPtr = NULL;

static volatile int last_current_mins = -1;  // not set yet
static volatile int current_mins = -1;

//struct timeval {
//  time_t      tv_sec;
//  suseconds_t tv_usec;
//};
// time_t is an intergal type that holds number of seconds elapsed since 00:00 hours, Jan 1, 1970 UTC (i.e., a unix timestamp).
// nullptr is a C++ null pointer literal which you can use anywhere you need to pass a null pointer.

//struct tm;
//Defined in header <time.h>
//Structure holding a calendar date and time broken down into its components.
//Member objects
//int tm_sec  seconds after the minute � [0, 61] (until C99)[0, 60] (since C99)[for leap second]
//int tm_min minutes after the hour � [0, 59]
//int tm_hour hours since midnight � [0, 23]
//int tm_mday day of the month � [1, 31]
//int tm_mon months since January � [0, 11]
//int tm_year years since 1900
//int tm_wday days since Sunday � [0, 6]
//int tm_yday days since January 1 � [0, 365]
//int tm_isdst Daylight Saving Time flag. The value is positive if DST is in effect, zero if not and negative if no information is available
//
//The Standard mandates only the presence of the aforementioned members in either order.
//The implementations usually add more data-members to this structure.

static volatile bool haveSNTPresponse = false;        // set true on first response


// only handles +v numbers
static void print2digits(String& result, uint num) {
  if (num < 10) {
    result += '0';
  }
  result += num;
}

String getHHMMss(struct tm* tmPtr) {
  String result;  // hh:mm:ss
  print2digits(result, tmPtr->tm_hour);
  result += ':';
  print2digits(result, tmPtr->tm_min);
  result += ':';
  print2digits(result, tmPtr->tm_sec);
  return result;
}

String getHHMM(struct tm* tmPtr) {
  String result;  // hh:mm:ss
  print2digits(result, tmPtr->tm_hour);
  result += ':';
  print2digits(result, tmPtr->tm_min);
  return result;
}

// local time of day HH:MM in mins i.e. 0 to 1439  or (unsigned int)-1 if no ntp yet
unsigned int getLocalTime_mins() {
  if (!haveSNTP()) {
    return -1;
  }
  time_t now = time(nullptr);
  struct tm* tmPtr = localtime(&now);
  unsigned int rtn = (tmPtr->tm_hour);
  rtn = rtn * 60 + tmPtr->tm_min;
  return rtn;
}

int haveSNTP() {
  if (haveSNTPresponse) {
    return 1;
  } 
  // else
  haveSNTPresponse = (sntp_get_sync_status() == SNTP_SYNC_STATUS_COMPLETED);
  if (haveSNTPresponse) {
    if (debugPtr) {
      debugPtr->println(" NTP received first response.");
    }
    return 1;
  }
  // else
  return 0;
}

// local time HH:MM:ss in sec
String getLocalTime_s() {
  if (!haveSNTP()) {
    return String("Not Set");
  }
  time_t now = time(nullptr);
  struct tm* tmPtr = localtime(&now);
  uint32_t rtn = (tmPtr->tm_hour);
  rtn = rtn * 60 + tmPtr->tm_min;
  rtn = rtn * 60 + tmPtr->tm_sec;
  return String(rtn);
}

// small String <=10char) in ESP8266/ESP32 use built in char[]
String getCurrentTime_hhmm() {
  if (!haveSNTP()) {
    return String("Not Set");
  }
  //  gettimeofday(&tv, nullptr);
  //  clock_gettime(0, &tp);
  time_t now = time(nullptr);
  struct tm* tmPtr = localtime(&now);
  return getHHMM(tmPtr);
}

String getUTCTime() {
  if (!haveSNTP()) {
    return String("Not Set");
  }
  //  gettimeofday(&tv, nullptr);
  //  clock_gettime(0, &tp);
  time_t now = time(nullptr);
  struct tm* tmPtr = gmtime(&now);
  return getHHMMss(tmPtr);
}

#define PTM(w) \
  debugPtr->print(" " #w "="); \
  debugPtr->print(tm->tm_##w);

void printTm(const char* what, const tm* tm) {
  if (!debugPtr) {
    return;
  }
  debugPtr->print(what);
  PTM(isdst);
  PTM(yday);
  PTM(wday);
  PTM(year);
  PTM(mon);
  PTM(mday);
  PTM(hour);
  PTM(min);
  PTM(sec);
}

void showTimeDebug() {
  if (!debugPtr) {
    return;
  }
  debugPtr->println(" -- ShowTimeDebug");
  timeval tv;
  timespec tp;
  time_t now;
  uint32_t now_ms, now_us;

  gettimeofday(&tv, nullptr);
  clock_gettime(0, &tp);
  now = time(nullptr);
  now_ms = millis();
  now_us = micros();

//  debugPtr->println();
  printTm("localtime:", localtime(&now));
  debugPtr->println();
  printTm("gmtime:   ", gmtime(&now));
  debugPtr->println();

  // time from boot
  debugPtr->print("clock:     ");
  debugPtr->print((uint32_t)tp.tv_sec);
  debugPtr->print("s + ");
  debugPtr->print((uint32_t)tp.tv_nsec);
  debugPtr->println("ns");

  // time from boot
  debugPtr->print("millis:    ");
  debugPtr->println(now_ms);
  debugPtr->print("micros:    ");
  debugPtr->println(now_us);

  // EPOCH+tz+dst
  debugPtr->print("gtod:      ");
  debugPtr->print((uint32_t)tv.tv_sec);
  debugPtr->print("s + ");
  debugPtr->print((uint32_t)tv.tv_usec);
  debugPtr->println("us");

  // EPOCH+tz+dst
  debugPtr->print("time:      ");
  debugPtr->println((uint32_t)now);

  // timezone and demo in the future
  debugPtr->printf("timezone:  %s\n", getenv("TZ") ?: "(none)");

  // human readable
  debugPtr->print("ctime:     ");
  debugPtr->print(ctime(&now));


// will pause for 1sec to check time changing
//  debugPtr->println();
  // show subsecond synchronisation
  // timeval prevtv;
  // time_t prevtime = time(nullptr);
  // gettimeofday(&prevtv, nullptr);

  // while (true) { 
  //   gettimeofday(&tv, nullptr);
  //   if (tv.tv_sec != prevtv.tv_sec) {
  //     debugPtr->printf("time(): %lu   gettimeofday(): %lu.%06lu  seconds are unchanged\n",
  //                      (uint32_t)prevtime,
  //                      (uint32_t)prevtv.tv_sec, (uint32_t)prevtv.tv_usec);
  //     debugPtr->printf("time(): %lu   gettimeofday(): %lu.%06lu  <-- seconds have changed\n",
  //                      (uint32_t)(prevtime = time(nullptr)),
  //                      (uint32_t)tv.tv_sec, (uint32_t)tv.tv_usec);
  //     break;
  //   }
  //   prevtv = tv;
  //   delay(1);
  // }
//  debugPtr->println();

}



bool initNTP() {
#ifdef DEBUG
  debugPtr = getDebugOut();
#endif
  if (debugPtr) {
    debugPtr->println("Setting up NTP time");
  }
  // just for testing get NTP every 1 min (60000ms)
  sntp_set_sync_interval(3600000); // 60ul*60000 once per hr
  configTime(0, 0, "pool.ntp.org");
  return true;
}
