/*
 * C4001_SafeString_Wrapper.h
 * Wrapper for DFRobot_C4001 sensor with SafeString support
 * Provides string outputs for status and motion detection
 * Provides int outputs for other variables
 * Handles conversion between UI units (seconds) and API units
 */

#ifndef C4001_SAFESTRING_WRAPPER_H
#define C4001_SAFESTRING_WRAPPER_H

#include <Arduino.h>
#include "../DFRobot_C4001.h"

class C4001_SafeString_Wrapper {
public:
  C4001_SafeString_Wrapper();

  // Set the sensor pointer
  void setSensor(DFRobot_C4001* sensor);

  // Status and detection getters (return string or status)
  const char* getStatusString();
  const char* getMotionDetectedString();

  // Distance getters (int, in cm)
  int getTrigDist();
  int getMaxDist();
  int getMinDist();

  // Delay getters (float, in seconds)
  float getTrigDelay();
  float getKeepDelay();

  // Sensitivity getters (int, 0-9)
  int getTrigSensitivity();
  int getKeepSensitivity();

  // Setters for inputs (take byte* from text input)
  void setTrigDist(const byte* inputBytes);
  void setMaxDist(const byte* inputBytes);
  void setMinDist(const byte* inputBytes);
  void setTrigDelay(const byte* inputBytes);
  void setKeepDelay(const byte* inputBytes);

  // Setters for sliders (take int column value 0-9)
  void setTrigSensitivity(int col);
  void setKeepSensitivity(int col);

  // Button handlers
  void buttonStart();
  void buttonStop();
  void buttonSave();
  void buttonReset();
  void buttonRestore();

private:
  DFRobot_C4001* _sensor;
  char _statusStr[60];
  char _motionStr[20];

  // Helper to validate and apply detection range (ensures min <= trig <= max)
  void validateAndSetDetectionRange();

  // Store current values for consistency checks
  uint16_t _minDist;
  uint16_t _maxDist;
  uint16_t _trigDist;
};

// Global instance
extern C4001_SafeString_Wrapper C4001_controls;

#endif
