#include "C1001_basics.h"

// Dwg_C1001_Presence.cpp  file ==============
// generated by pfodWeb Designer Arduino Export V2.0.0 -- 13th October 2025
/*   
 * (c)2025 Forward Computing and Control Pty. Ltd.
 * NSW Australia, www.forward.com.au
 * This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 * This generated code may be freely used for both private and commercial use
 * provided this copyright is maintained.
 */

#include "Dwg_C1001_Presence.h"
#include <pfodDebugPtr.h>

//#define DEBUG
static Print* debugPtr = NULL;  // local to this file

Dwg_C1001_Presence dwg_C1001_Presence;


static unsigned long dwgRefresh = 1000;

Dwg_C1001_Presence::Dwg_C1001_Presence() {
  initialized = false;
}

void Dwg_C1001_Presence::init() {
  if (initialized) {
    return;
  }
  initialized = true;
  (void)debugPtr;  // suppress unused warning
#ifdef DEBUG
  debugPtr = getDebugPtr();
#endif
  pfodDrawing::init();
}

// return true if handled else false
// either handle cmd here or in main sketch
bool Dwg_C1001_Presence::processDwgCmds() {
// byte dwgCmd = parserPtr->parseDwgCmd(); // pfodParse calls this automagically before calling this method
  if (!(*(parserPtr->getDwgCmd()))) {  // ==> getDwgCmd returned pointer to empty string
    return false; // not dwg cmd, not handled
  }

  // if (debugPtr) { debugPtr->print("dwgCmd did not match:"); debugPtr->println(cmd_c1); }
  return false; // not handled
}

bool Dwg_C1001_Presence::sendDwg() {
  if (!parserPtr->cmdEquals(*this)) {
    return false; // not this dwg's loadCmd
  }  // else
  if (parserPtr->isRefresh()) { // refresh just send update
    sendUpdate();
  } else {
    sendFullDrawing();
  }
  return true;
}

// all the indexed items are included here, edit as needed for updates
// Note when updating drawing keep the get...() code
void Dwg_C1001_Presence::sendIndexedItems() {
    dwgsPtr->label().idx(idx_presence).color(dwgsPtr->BLACK_WHITE).text(getPresence()).offset(0,10).left().decimals(2).send();
    dwgsPtr->label().idx(idx_movement).color(dwgsPtr->BLACK_WHITE).text(getMovement()).offset(0,14).left().decimals(2).send();
    dwgsPtr->label().idx(idx_range).color(dwgsPtr->BLACK_WHITE).text(getMovementRange()).offset(0,18).left().decimals(0).send();
    dwgsPtr->label().idx(idx_respiration).color(dwgsPtr->BLACK_WHITE).text(getRespiration()).offset(0,22).left().decimals(0).send();
    dwgsPtr->label().idx(idx_heartRate).color(dwgsPtr->BLACK_WHITE).text(getHeartRate()).offset(0,26).left().decimals(0).send();
}
        
void Dwg_C1001_Presence::sendFullDrawing() {
    // Start the drawing
    dwgsPtr->start(55, 30, dwgsPtr->BLUE);
    parserPtr->sendRefreshAndVersion(dwgRefresh); // sets version and refresh time for dwg pfodWeb processes this
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("C1001 Presence Detector").fontSize(2).offset(27.5,4).center().decimals(2).send();
    dwgsPtr->pushZero(33, 0, 1);
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("Someone Present -").offset(0,10).right().decimals(2).send();
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("Moving -").offset(0,14).right().decimals(2).send();
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("Movement Range -").offset(0,18).right().decimals(2).send();
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("Respiration Rate -").offset(0,22).right().decimals(2).send();
    dwgsPtr->label().color(dwgsPtr->BLACK_WHITE).text("Heart Rate -").offset(0,26).right().decimals(2).send();
    dwgsPtr->popZero();
    dwgsPtr->pushZero(34, 0, 1);
    dwgsPtr->index().idx(idx_presence).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_movement).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_range).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_respiration).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_heartRate).send(); // place holder for indexed item
    dwgsPtr->popZero();
    sendIndexedItems(); // update indexed items with their real values
    dwgsPtr->end();
}
        
// only indexed items can be sent as an update
// all the indexed items are included here, edit as needed
void Dwg_C1001_Presence::sendUpdate() {
    dwgsPtr->startUpdate();
    sendIndexedItems(); // send updated indexed items        
    dwgsPtr->end();
}
// ============== end of Dwg_C1001_Presence.cpp  file 
